'---------------------------------------------------------------------------------------------------
' This program was written with BLIde (www.blide.org)
' Application: BitWave X
' Author: Kippykip
' License: idk lol
'---------------------------------------------------------------------------------------------------
Import maxmod2.RtAudio
'Import maxmod2.Dumb
'Import beanage.fbo

'Include these
Include "KFS.bmx"
Include "KGFX.bmx"
'Include "Render2Texture.bmx"

SetAudioDriver("MaxMod RtAudio") 
SetGraphicsDriver GLMax2DDriver() 
AppTitle:String = DEFS.TITLE
'THIS STUFF HERE LETS ME USE A SETBUFFER!
Graphics(DEFS.External_ResX, DEFS.External_ResY, DEFS.External_Depth, 60) 
'TImageBuffer.Init(DEFS.External_ResX, DEFS.External_ResY, DEFS.External_Depth, 60) 
'Local IB:TImageBuffer = TImageBuffer.SetBuffer(DEFS.VBuffer) 

'Local MyGraphics:TGraphics = Graphics(DEFS.External_ResX, DEFS.External_ResY) 
glewInit() 
Global VBufferGFX:TGLMax2DFBO = TGLMax2DFBO.ForImage(DEFS.VBuffer) 

Type DEFS
	Global TITLE:String = "BitWave X"
	Const Internal_ResX:Int = 320
	Const Internal_ResY:Int = 240
	'Global External_ResX:Int = DesktopWidth() 
	'Global External_ResY:Int = DesktopHeight() 
	Global External_ResX:Int = 1280
	Global External_ResY:Int = 800
	Global External_Depth:Int = 0
	Global VBuffer:TImage = CreateImage(Internal_ResX, Internal_ResY, 1, 0) 
	Global VBufferBinded = False
	Global FPSCAP = CreateTimer(60) 
	Global CameraX:Int = 0
	Global CameraY:Int = 0
	Global GameMode:Int = 0	'Menus/Game/Level editor etc
	Global GameLoaded = False 'To know if you're already in a game, for pausing.
	'Constants
	Const BlockWidth:Int = 8
	Const FadeSpeed:Int = 4
	
	Function ScaleRes() 
		'Scale the virtual resolution
		GrabImage(DEFS.VBuffer, 0, 0)  
		SetColor(255, 255, 255) 
		SetScale(1, 1) 
		DrawImageRect(DEFS.VBuffer, 0, 0, GraphicsWidth(), GraphicsHeight()) 
	End Function
	
	Function UpdateObjects() 
		Block.Update() 
		Ladder.Update() 
		Player.Update() 
	End Function
	'Why the fuck not have a cool glitchy looking crash?
	Function Crash(TMP_Reason:String = "UNK") 
		DrawText("CRASH STATE: " + TMP_Reason:String, 0, 0) 
		Print("CRASH STATE: " + TMP_Reason:String) 
		VBufferGFX.unbind() 
		'DrawImageRect(DEFS.VBuffer, 0, 0, GraphicsWidth(), GraphicsHeight()) 
		'DrawText("CRASH STATE: " + TMP_Reason:String, 0, 0) 
		SND.PlaySong() 
		While Not AppTerminate() 
			DrawImageRect(DEFS.VBuffer, 0, Rand(0, 2) * 16, GraphicsWidth(), GraphicsHeight()) 
			If(IMG.INTERLACE) 
				TileImage(IMG.INTERLACE) 
			EndIf
			Flip
			WaitTimer(DEFS.FPSCAP) 
		Wend
		'DEFS.ScaleRes() 
		
		'Flip
		'WaitKey
		End
	End Function
End Type

Type IMG
	Global INTERLACE:TImage
	Global BORDER:TImage
	Global CHECKERB:TImage
	
	'Fading stuff
	Global Fade:Int = 0
	Global FadeFrame:Int = 0
	Global FadeQueue:String
	Global FadeSpeed:Int = DEFS.FadeSpeed
	Global IsFaded = False
	Global FadeIMGRendered = False
	
	Global Brick1_001:TImage
	Global Brick2_001:TImage
	Global Brick3_001:TImage
	Global Brick4_001:TImage
	Global Brick5_001:TImage
	Global Brick6_001:TImage
	Global Brick7_001:TImage
	Global Brick8_001:TImage
	Global Brick9_001:TImage
	Global Brick10_001:TImage
	Global Brick11_001:TImage
	Global Brick12_001:TImage
	Global Brick13_001:TImage
	Global Brick14_001:TImage
	Global Brick15_001:TImage
	
	Global Brick1_002:TImage
	Global Brick2_002:TImage
	Global Brick3_002:TImage
	Global Brick4_002:TImage
	Global Brick5_002:TImage
	Global Brick6_002:TImage
	Global Brick7_002:TImage
	Global Brick8_002:TImage
	Global Brick9_002:TImage
	Global Brick10_002:TImage
	Global Brick11_002:TImage
	Global Brick12_002:TImage
	Global Brick13_002:TImage
	Global Brick14_002:TImage
	Global Brick15_002:TImage
	
	'Ladders
	Global Ladder1_01:TImage
	Global Ladder2_01:TImage
	Global Ladder3_01:TImage
	Global Ladder4_01:TImage
	Global Ladder5_01:TImage
	Global Ladder6_01:TImage
	Global Ladder7_01:TImage
	Global Ladder8_01:TImage
	Global Ladder9_01:TImage
	Global Ladder10_01:TImage
	Global Ladder11_01:TImage
	Global Ladder12_01:TImage
	Global Ladder13_01:TImage
	Global Ladder14_01:TImage
	Global Ladder15_01:TImage
	
	'Player
	'Walking
	Global PLRWLK01:TImage
	Global PLRWLK02:TImage
	Global PLRWLK03:TImage
	Global PLRWLK04:TImage
	Global PLRWLK05:TImage
	Global PLRWLK06:TImage
	'Idle
	Global PLRIDL01:TImage
	Global PLRIDL02:TImage
	'Climbing
	Global PLRCLB01:TImage
	Global PLRCLB02:TImage
	Global PLRCLB03:TImage
	Global PLRCLB04:TImage
	Global PLRCLB05:TImage
	
	Function LoadRes() 
		IMG.INTERLACE:TImage = LoadImage(ARCH_Read("INTERLAC"), 0) 
		IMG.BORDER:TImage = LoadImage(ARCH_Read("BORDER01"), 0) 
		IMG.CHECKERB:TImage = LoadImage(ARCH_Read("CHECKERB"), 0) 
		IMG.Brick1_001:TImage = GFX.KConvertImage("BRICK001", 4 * 0) 
		IMG.Brick2_001:TImage = GFX.KConvertImage("BRICK001", 4 * 1) 
		IMG.Brick3_001:TImage = GFX.KConvertImage("BRICK001", 4 * 2) 
		IMG.Brick4_001:TImage = GFX.KConvertImage("BRICK001", 4 * 3) 
		IMG.Brick5_001:TImage = GFX.KConvertImage("BRICK001", 4 * 4) 
		IMG.Brick6_001:TImage = GFX.KConvertImage("BRICK001", 4 * 5) 
		IMG.Brick7_001:TImage = GFX.KConvertImage("BRICK001", 4 * 6) 
		IMG.Brick8_001:TImage = GFX.KConvertImage("BRICK001", 4 * 7) 
		IMG.Brick9_001:TImage = GFX.KConvertImage("BRICK001", 4 * 8) 
		IMG.Brick10_001:TImage = GFX.KConvertImage("BRICK001", 4 * 9) 
		IMG.Brick11_001:TImage = GFX.KConvertImage("BRICK001", 4 * 10) 
		IMG.Brick12_001:TImage = GFX.KConvertImage("BRICK001", 4 * 11) 
		IMG.Brick13_001:TImage = GFX.KConvertImage("BRICK001", 4 * 12) 
		IMG.Brick14_001:TImage = GFX.KConvertImage("BRICK001", 4 * 13) 
		IMG.Brick15_001:TImage = GFX.KConvertImage("BRICK001", 4 * 14) 
		
		IMG.Brick1_002:TImage = GFX.KConvertImage("BRICK002", 4 * 0) 
		IMG.Brick2_002:TImage = GFX.KConvertImage("BRICK002", 4 * 1) 
		IMG.Brick3_002:TImage = GFX.KConvertImage("BRICK002", 4 * 2) 
		IMG.Brick4_002:TImage = GFX.KConvertImage("BRICK002", 4 * 3) 
		IMG.Brick5_002:TImage = GFX.KConvertImage("BRICK002", 4 * 4) 
		IMG.Brick6_002:TImage = GFX.KConvertImage("BRICK002", 4 * 5) 
		IMG.Brick7_002:TImage = GFX.KConvertImage("BRICK002", 4 * 6) 
		IMG.Brick8_002:TImage = GFX.KConvertImage("BRICK002", 4 * 7) 
		IMG.Brick9_002:TImage = GFX.KConvertImage("BRICK002", 4 * 8) 
		IMG.Brick10_002:TImage = GFX.KConvertImage("BRICK002", 4 * 9) 
		IMG.Brick11_002:TImage = GFX.KConvertImage("BRICK002", 4 * 10) 
		IMG.Brick12_002:TImage = GFX.KConvertImage("BRICK002", 4 * 11) 
		IMG.Brick13_002:TImage = GFX.KConvertImage("BRICK002", 4 * 12) 
		IMG.Brick14_002:TImage = GFX.KConvertImage("BRICK002", 4 * 13) 
		IMG.Brick15_002:TImage = GFX.KConvertImage("BRICK002", 4 * 14) 
		
		IMG.Ladder1_01:TImage = GFX.KConvertImage("LADDER01", 4 * 0) 
		IMG.Ladder2_01:TImage = GFX.KConvertImage("LADDER01", 4 * 1) 
		IMG.Ladder3_01:TImage = GFX.KConvertImage("LADDER01", 4 * 2) 
		IMG.Ladder4_01:TImage = GFX.KConvertImage("LADDER01", 4 * 3) 
		IMG.Ladder5_01:TImage = GFX.KConvertImage("LADDER01", 4 * 4) 
		IMG.Ladder6_01:TImage = GFX.KConvertImage("LADDER01", 4 * 5) 
		IMG.Ladder7_01:TImage = GFX.KConvertImage("LADDER01", 4 * 6) 
		IMG.Ladder8_01:TImage = GFX.KConvertImage("LADDER01", 4 * 7) 
		IMG.Ladder9_01:TImage = GFX.KConvertImage("LADDER01", 4 * 8) 
		IMG.Ladder10_01:TImage = GFX.KConvertImage("LADDER01", 4 * 9) 
		IMG.Ladder11_01:TImage = GFX.KConvertImage("LADDER01", 4 * 10) 
		IMG.Ladder12_01:TImage = GFX.KConvertImage("LADDER01", 4 * 11) 
		IMG.Ladder13_01:TImage = GFX.KConvertImage("LADDER01", 4 * 12) 
		IMG.Ladder14_01:TImage = GFX.KConvertImage("LADDER01", 4 * 13) 
		IMG.Ladder15_01:TImage = GFX.KConvertImage("LADDER01", 4 * 14) 
		
		'Walk
		IMG.PLRWLK01:TImage = GFX.KConvertImage("PLRWLK01") 
		IMG.PLRWLK02:TImage = GFX.KConvertImage("PLRWLK02") 
		IMG.PLRWLK03:TImage = GFX.KConvertImage("PLRWLK03") 
		IMG.PLRWLK04:TImage = GFX.KConvertImage("PLRWLK04") 
		IMG.PLRWLK05:TImage = GFX.KConvertImage("PLRWLK05") 
		IMG.PLRWLK06:TImage = GFX.KConvertImage("PLRWLK06") 
		'Idle
		IMG.PLRIDL01:TImage = GFX.KConvertImage("PLRIDL01") 
		IMG.PLRIDL02:TImage = GFX.KConvertImage("PLRIDL02") 
		'Climb
		IMG.PLRCLB01:TImage = GFX.KConvertImage("PLRCLB01") 
		IMG.PLRCLB02:TImage = GFX.KConvertImage("PLRCLB02") 
		IMG.PLRCLB03:TImage = GFX.KConvertImage("PLRCLB03") 
		IMG.PLRCLB04:TImage = GFX.KConvertImage("PLRCLB04") 
		IMG.PLRCLB05:TImage = GFX.KConvertImage("PLRCLB05") 
	End Function
	
    'Fading Effect
	Function UpdateFade() 
		'Debug Keys
		If(KeyHit(KEY_Q)) 
			IMG.Fade = IMG.Fade - 1
		EndIf
		If(KeyHit(KEY_W)) 
			IMG.Fade = IMG.Fade + 1
		EndIf
		If(KeyHit(KEY_E)) 
			IMG.FadeOut() 
		EndIf
		If(KeyHit(KEY_R)) 
			IMG.FadeIn() 
		EndIf
		'Loop this until the fade is done, so it doesn't go through game logic
		While(IMG.FadeQueue:String.Length > 0) 
			If(Left:String(IMG.FadeQueue:String, 1) = "1")  'Out
				IMG.FadeFrame:Int = IMG.FadeFrame:Int + 1
				If(IMG.FadeFrame:Int > IMG.FadeSpeed:Int) 
					IMG.Fade:Int = IMG.Fade:Int + 1
					IMG.FadeFrame:Int = 0
				EndIf
				If(IMG.Fade:Int >= 5) 
					IMG.FadeQueue:String = Right:String(IMG.FadeQueue:String, IMG.FadeQueue:String.Length - 1) 
					IMG.Fade:Int = 5
				EndIf
			EndIf
			If(Left:String(IMG.FadeQueue:String, 1) = "0")  'In
				IMG.FadeFrame:Int = IMG.FadeFrame:Int + 1
				If(IMG.FadeFrame:Int > IMG.FadeSpeed:Int) 
					IMG.Fade:Int = IMG.Fade:Int - 1
					IMG.FadeFrame:Int = 0
				EndIf
				If(IMG.Fade:Int <= 0) 
					IMG.FadeQueue:String = Right:String(IMG.FadeQueue:String, IMG.FadeQueue:String.Length - 1) 
					IMG.Fade:Int = 0
				EndIf
			EndIf
			
			'Start upgrading Graphics
			IMG.DrawFade() 
			Cls
			IMG.ScaleGraphics() 
			TileImage(IMG.INTERLACE, 0, Rand(0, 1))          'Minor PostFX
			DrawText(IMG.FadeFrame:Int + ":" + IMG.FadeQueue, 0, 0) 
			Flip 1
			WaitTimer(DEFS.FPSCAP) 
		Wend
		If(IMG.Fade:Int >= 4) 
			IMG.IsFaded = True
		Else
			IMG.IsFaded = False
		EndIf
	End Function
	
	Function DrawFade() 
		If(IMG.Fade:Int = 1) 
			DrawImageRect(IMG.CHECKERB, (GraphicsWidth() - (GraphicsHeight() * 4 / 3)) / 2, 0, GraphicsHeight() * 4 / 3, GraphicsHeight()) 
		ElseIf(IMG.Fade:Int = 2) 
			SetColor(0, 0, 0) 
			SetAlpha 0.5
			DrawRect((GraphicsWidth() - (GraphicsHeight() * 4 / 3)) / 2, 0, GraphicsHeight() * 4 / 3, GraphicsHeight()) 
			SetColor(255, 255, 255) 
			SetAlpha(1) 
		ElseIf(IMG.Fade:Int = 3) 
			DrawImageRect(IMG.CHECKERB, (GraphicsWidth() - (GraphicsHeight() * 4 / 3)) / 2, 0, GraphicsHeight() * 4 / 3, GraphicsHeight()) 
			SetColor(0, 0, 0) 
			SetAlpha 0.5
			DrawRect((GraphicsWidth() - (GraphicsHeight() * 4 / 3)) / 2, 0, GraphicsHeight() * 4 / 3, GraphicsHeight()) 
			SetColor(255, 255, 255) 
			SetAlpha(1) 
		ElseIf(IMG.Fade:Int >= 4) 
			SetColor(0, 0, 0) 
			SetAlpha(1) 
			DrawRect((GraphicsWidth() - (GraphicsHeight() * 4 / 3)) / 2, 0, GraphicsHeight() * 4 / 3, GraphicsHeight()) 
			SetColor(255, 255, 255) 
		EndIf
	End Function
	
	'Advanced trickery so it doesn't fade both at the same time
	Function FadeOut(TMP_Speed:Int = DEFS.FadeSpeed) 
		IMG.FadeSpeed:Int = TMP_Speed:Int
		IMG.FadeQueue:String = IMG.FadeQueue:String + "1"
		IMG.UpdateFade() 
	End Function
	
	Function FadeIn(TMP_Speed:Int = DEFS.FadeSpeed) 
		IMG.FadeSpeed:Int = TMP_Speed:Int
		IMG.FadeQueue:String = IMG.FadeQueue:String + "0"
		IMG.UpdateFade() 
	End Function
	
	'effects, like borders, stretching etc
	Function ScaleGraphics() 
		'Go back to the main buffer
		If(DEFS.VBufferBinded) 
			VBufferGFX.unbind() 
			DEFS.VBufferBinded = False
		EndIf
		SetColor(255, 255, 255) 
		SetScale(1, 1) 
		TileImage(IMG.BORDER) 
		'CLS COLOR
		SetColor(0, 0, 0) 
		DrawRect((GraphicsWidth() - (GraphicsHeight() * 4 / 3)) / 2, 0, GraphicsHeight() * 4 / 3, GraphicsHeight()) 
		SetColor(255, 255, 255) 
		DrawImageRect(DEFS.VBuffer, (GraphicsWidth() - (GraphicsHeight() * 4 / 3)) / 2, 0, GraphicsHeight() * 4 / 3, GraphicsHeight()) 
		TileImage(IMG.INTERLACE, 0, Rand(0, 1))        'Minor PostFX
		Flip 1
		WaitTimer(DEFS.FPSCAP) 
	End Function
End Type

Type SND
	Global Music:TChannel
	Global SStep:TSound
	Global SClimb:TSound
	Global MusicVol:Float = 0.5
	Global OPLMode = False 'This is the best shit I've ever done holy fuck
	Global CurrentMus:String = "DEAD.MUS"

	Function LoadRes() 
		SND.SStep = LoadSound(ARCH_Read("S_PLRSTP")) 
		SND.SClimb = LoadSound(ARCH_Read("S_PLRCLB")) 
	End Function
	Function PlaySong(TMP_SONGNAME:String = "DEAD.MUS") 
		If(SND.Music) 
			StopChannel(SND.Music) 
		EndIf
		'SND.Music:TChannel = CueMusic(ARCH_ReadXM(TMP_SONGNAME:String, SND.OPLMode), True) 
		'SetChannelVolume(SND.Music, SND.MusicVol) 
		'ResumeChannel SND.Music
	End Function
End Type

Rem
Type BlockFallTrans
	Global BlockFallTrans_List:TList = New TList
	Field Name:String
	Field X:Int
	Field Y:Int
	Field FinY:Int
	Field Colour:Int
	Field Deactivate
	Global YLimit:Int[] = New Int[40] 
	'YLimit = New Int[40] 
	Function Add(TMP_X:Int, TMP_Y:Int, TMP_Colour:Int) 
		Local CABNET:BlockFallTrans = New BlockFallTrans
		CABNET.X:Int = TMP_X:Int * 8
		CABNET.Y:Int = TMP_Y:Int * 8
		CABNET.Colour = TMP_Colour
		CABNET.Deactivate = False
		ListAddLast(BlockFallTrans_List, CABNET) 
	EndFunction
	Function Update() 
		For Local CABNET:BlockFallTrans = EachIn BlockFallTrans_List
			If(CABNET.Deactivate = False) 
				If(CABNET.Y < DEFS.Internal_ResY - 8 + BlockFallTrans.YLimit[CABNET.X / 8] ) 
					CABNET.Y = CABNET.Y + 8
				Else
					BlockFallTrans.YLimit[CABNET.X / 8] = BlockFallTrans.YLimit[CABNET.X / 8] - 8
					CABNET.Y = DEFS.Internal_ResY + BlockFallTrans.YLimit[CABNET.X / 8] 
					CABNET.Deactivate = True
				EndIf
			EndIf
			If(CABNET.Colour = 0) 
				DrawImage(IMG.Brick1, CABNET.X, CABNET.Y) 
			ElseIf(CABNET.Colour = 1) 
				DrawImage(IMG.Brick2, CABNET.X, CABNET.Y) 
			ElseIf(CABNET.Colour = 2) 
				DrawImage(IMG.Brick3, CABNET.X, CABNET.Y) 
			ElseIf(CABNET.Colour = 3) 
				DrawImage(IMG.Brick4, CABNET.X, CABNET.Y) 
			ElseIf(CABNET.Colour = 4) 
				DrawImage(IMG.Brick5, CABNET.X, CABNET.Y) 
			ElseIf(CABNET.Colour = 5) 
				DrawImage(IMG.Brick6, CABNET.X, CABNET.Y) 
			ElseIf(CABNET.Colour = 6) 
				DrawImage(IMG.Brick7, CABNET.X, CABNET.Y) 
			ElseIf(CABNET.Colour = 7) 
				DrawImage(IMG.Brick8, CABNET.X, CABNET.Y) 
			ElseIf(CABNET.Colour = 8) 
				DrawImage(IMG.Brick9, CABNET.X, CABNET.Y) 
			ElseIf(CABNET.Colour = 9) 
				DrawImage(IMG.Brick10, CABNET.X, CABNET.Y) 
			ElseIf(CABNET.Colour = 10) 
				DrawImage(IMG.Brick11, CABNET.X, CABNET.Y) 
			ElseIf(CABNET.Colour = 11) 
				DrawImage(IMG.Brick12, CABNET.X, CABNET.Y) 
			ElseIf(CABNET.Colour = 12) 
				DrawImage(IMG.Brick13, CABNET.X, CABNET.Y) 
			ElseIf(CABNET.Colour = 13) 
				DrawImage(IMG.Brick14, CABNET.X, CABNET.Y) 
			ElseIf(CABNET.Colour = 14) 
				DrawImage(IMG.Brick15, CABNET.X, CABNET.Y) 
			EndIf
		Next
	End Function
EndType
endrem

Type Block
	Global Block_List:TList = New TList
	Field BlockType:TImage
	Field POS_X:Int = 0
	Field POS_Y:Int = 0
	'Add a block
	Function Add(TMP_X:Int, TMP_Y:Int, TMP_BlockType:TImage) 
		Local CABNET:Block = New Block
		CABNET.POS_X:Int = TMP_X:Int * DEFS.BlockWidth:Int
		CABNET.POS_Y:Int = TMP_Y:Int * DEFS.BlockWidth:Int
		CABNET.BlockType = TMP_BlockType
		ListAddLast(Block_List, CABNET) 
	EndFunction
	'Draw block with camera etc
	Function Update(TMP_AllowLogic = True) 
		For Local CABNET:Block = EachIn Block_List
			TMP_IMG:TImage = CABNET.BlockType
			DrawImageRect(TMP_IMG, CABNET.POS_X:Int - DEFS.CameraX, CABNET.POS_Y:Int - DEFS.CameraY, DEFS.BlockWidth, DEFS.BlockWidth) 
		Next
	End Function
	'Checks whether a block is at a coodinate
	Function CHKBlock(TMP_X:Int, TMP_Y:Int) 
		TMP_Answer = False
		For Local CABNET:Block = EachIn Block_List
			If(TMP_X:Int = CABNET.POS_X) 
				If(TMP_Y:Int = CABNET.POS_Y) 
					TMP_Answer = True
				EndIf
			EndIf
		Next
		Return TMP_Answer
	End Function
End Type

Type Ladder
	Global Ladder_List:TList = New TList
	Field POS_X:Int = 0
	Field POS_Y:Int = 0
	Field BlockType:TImage
	
	'Add a ladder
	Function Add(TMP_X:Int, TMP_Y:Int, TMP_BlockType:TImage) 
		Local CABNET:Ladder = New Ladder
		CABNET.POS_X:Int = TMP_X:Int * DEFS.BlockWidth:Int
		CABNET.POS_Y:Int = TMP_Y:Int * DEFS.BlockWidth:Int
		CABNET.BlockType = TMP_BlockType
		ListAddLast(Ladder_List, CABNET) 
	EndFunction
	'Draw block with camera etc
	Function Update(TMP_AllowLogic = True) 
		For Local CABNET:Ladder = EachIn Ladder_List
			TMP_IMG:TImage = CABNET.BlockType
			DrawImageRect(TMP_IMG, CABNET.POS_X:Int - DEFS.CameraX, CABNET.POS_Y:Int - DEFS.CameraY, DEFS.BlockWidth, DEFS.BlockWidth) 
		Next
	End Function
	'Checks whether a block is at a coodinate
	Function CHKBlock(TMP_X:Int, TMP_Y:Int) 
		TMP_Answer = False
		For Local CABNET:Ladder = EachIn Ladder_List
			If(TMP_X:Int = CABNET.POS_X) 
				If(TMP_Y:Int = CABNET.POS_Y) 
					TMP_Answer = True
				EndIf
			EndIf
		Next
		Return TMP_Answer
	End Function
End Type

Type Player
	Global NextFrameDelay = 0
	Global WalkingFrame = 0
	Global IdleFrame = 0
	Global ClimbingFrame = 0
	Global POS_X:Int = 0
	Global POS_Y:Int = 0
	Global Animation:Int = 0 '0 = Idle, 1 = Walking, 2 = Jumping, 3 = Climbing
	Global IsJumping = False
	Global IsRunning = False
	Global JumpState:Int = 0
	Global Speed:Int = 1
	Global IsReady = True
	Global DestX:Int = 0
	Global DestY:Int = 0
	Global DirectionTMR:Int = 4 'Small delay so you can change direction without moving
	Global DirectionTMRCAP:Int = 4 'Max Delay
	Global Direction:Int = 1
	Global OnGround:Int = True
	Global IMG_Frame:TImage
	'Global IsDead = False
	
	Function ResetVars() 
		Player.NextFrameDelay = 0
		Player.WalkingFrame = 0
		Player.IdleFrame = 0
		Player.ClimbingFrame = 0
		Player.POS_X:Int = 0
		Player.POS_Y:Int = 0
		Player.Animation:Int = 0
		Player.IsJumping = False
		Player.IsRunning = False
		Player.JumpState:Int = 0
		Player.Speed:Int = 1
		Player.IsReady = True
		Player.DestX:Int = 0
		Player.DestY:Int = 0
		Player.DirectionTMR:Int = 4
		Player.DirectionTMRCAP:Int = 4
		Player.Direction:Int = 1
		Player.OnGround:Int = True
		Player.IMG_Frame:TImage = IMG.PLRIDL01
	'	Player.IsDead = False
	End Function
		
	Function Update() 
		'X movement
		If(Player.DestX:Int = 0 And Player.DestY:Int = 0) 
			Player.IsReady = True
			If(KeyDown(KEY_LSHIFT)) 
				Player.IsRunning = True
			Else
				Player.IsRunning = False
			EndIf
		Else
			If(Player.DestX:Int > 0) 
				Player.POS_X:Int = Player.POS_X:Int + Player.Speed:Int
				Player.DestX:Int = Player.DestX:Int - Player.Speed:Int
				Player.Direction:Int = 1
			EndIf
			If(Player.DestX:Int < 0) 
				Player.POS_X:Int = Player.POS_X:Int - Player.Speed:Int
				Player.DestX:Int = Player.DestX:Int + Player.Speed:Int
				Player.Direction:Int = -1
			EndIf
			'Y Movement
			If(Player.DestY:Int > 0) 
				Player.POS_Y:Int = Player.POS_Y:Int + Player.Speed:Int
				Player.DestY:Int = Player.DestY:Int - Player.Speed:Int
			EndIf
			If(Player.DestY:Int < 0) 
				Player.POS_Y:Int = Player.POS_Y:Int - Player.Speed:Int
				Player.DestY:Int = Player.DestY:Int + Player.Speed:Int
			EndIf
			Player.IsReady = False
		EndIf
		
		'Player Animations etc
		If(Player.Animation = 0)  'Idle
			Player.UpdateIdleCycle() 
		ElseIf(Player.Animation = 1)  'Walking/Running
			Player.UpdateWalkCycle() 
		ElseIf(Player.Animation = 3)   'Climbing
			Player.UpdateClimbCycle() 
		ElseIf(Player.Animation = 4)   'Climbing - But idle
			Player.IMG_Frame = IMG.PLRCLB02
		EndIf
		
		'Camera!
		DEFS.CameraX = Player.POS_X - (DEFS.Internal_ResX / 2) 
		DEFS.CameraY = Player.POS_Y - (DEFS.Internal_ResY / 2) 
		If(DEFS.CameraX < 0) 
			DEFS.CameraX = 0
		EndIf
		If(DEFS.CameraX > Map.MapSizeX:Int) 
			DEFS.CameraX = Map.MapSizeX:Int
		EndIf
		'Y
		If(DEFS.CameraY < 0) 
			DEFS.CameraY = 0
		EndIf
		'This shit took fucking forever to figure out
		'So first we get the mapsize which is based from the blockwidth, so multiply that to find the actual pixel size.
		'So now the camera is on the exact last block, but since the cameras X,Y is based from the very top left corner, we need to flip it
		'Can easily be done by subtracting the vertical screen resolution. Works great. But I'd still like to see the very last block
		'So another 8 pixels (blockwidth) is added at the very end just to see that 1 extra block.
		If(DEFS.CameraY >= Map.MapSizeY:Int * DEFS.BlockWidth:Int - DEFS.Internal_ResY:Int + DEFS.BlockWidth:Int) 
			'WaitKey
			DEFS.CameraY = Map.MapSizeY:Int * DEFS.BlockWidth:Int - DEFS.Internal_ResY:Int + DEFS.BlockWidth:Int
		EndIf
		'DrawRect(DEFS.CameraX, 16, 8, 8) 
		'Print Player.JumpState
		If(Player.IsReady) 
			'Kill player if offscreen
		'	Print Map.MapSizeY:Int * 8 + ":" + Map.MapSizeY:Int + ":" + Player.POS_Y + ":" + DEFS.CameraY
			If(Player.POS_X:Int < 0 Or Player.POS_Y:Int >= Map.MapSizeY:Int * DEFS.BlockWidth:Int + DEFS.BlockWidth:Int) 
				Player.Die() 
			EndIf
			'Print Player.POS_X
			If(Ladder.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int)) 
				Player.Animation:Int = 4 'Gripping on ladder
			Else
				Player.Animation:Int = 0
			EndIf
			'Crash if you merge in a solid object
			If(Block.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int)) 
				DEFS.Crash("PLR MISALIGNED") 
			EndIf
			'Jumping!
			If(Player.IsJumping) 
				If(Player.JumpState = 0) 
					Player.Move(0, - 1, 2) 
					Player.JumpState = 1
					'print "JUMPSTART"
				ElseIf(Player.JumpState = 1) 
					'Print Player.JumpState
					Player.JumpState = 2
					Player.Move(Player.Direction, 0, 2) 
				ElseIf(Player.JumpState = 2) 
					Print Player.JumpState
					'Did he land on a block?
					If(Block.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int + DEFS.BlockWidth:Int) Or Ladder.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int)) 
						Player.JumpState = 4
					Else 'No? There isn't a block next to you right?
						If(Block.CHKBlock(Player.POS_X:Int + (DEFS.BlockWidth:Int * Player.Direction), Player.POS_Y:Int)) 
							Player.JumpState = 4
						Else
							Player.JumpState = 3
							Player.Move(Player.Direction, 0, 2) 
						EndIf
					EndIf
				ElseIf(Player.JumpState = 3) 
					Print Player.JumpState
					'Did he land on a block?
					If(Block.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int + DEFS.BlockWidth:Int) = False And Ladder.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int) = False) 
						'No? There isn't a block next to you right?
						If(Block.CHKBlock(Player.POS_X:Int + (DEFS.BlockWidth:Int * Player.Direction), Player.POS_Y:Int)) 
						Else
							Player.Move(Player.Direction, 0, 2) 
						EndIf
						Player.JumpState = 4
					EndIf
					Player.JumpState = 4
				ElseIf(Player.JumpState = 4) 
					Player.IsJumping = False
					Player.JumpState = 0
				EndIf
			Else
				'On ground checkup
				'Is there a block underneath the player?
				If(Block.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int + DEFS.BlockWidth:Int) Or Ladder.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int) Or Ladder.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int + DEFS.BlockWidth:Int)) 
					'OH BOI! Little animation when you land!??!?!
					If(Player.OnGround = False) 
						Player.NextFrameDelay = 0
						Player.IdleFrame = 8
					EndIf
					Player.OnGround = True
				Else
					Player.OnGround = False
				EndIf
				'Are you on the ground?
				If(Player.OnGround) 
					'Movement
					'Jump left
					If(KeyDown(KEY_Z)) 
						'Is there any blocks above the player?
						If(Block.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int - DEFS.BlockWidth:Int) = False) 
							If(Block.CHKBlock(Player.POS_X:Int - DEFS.BlockWidth:Int, Player.POS_Y:Int - DEFS.BlockWidth:Int) = False) 
								Player.IsJumping = True
								Player.IsReady = False
								Player.Direction = -1
							EndIf
						EndIf
						'Jump right
					ElseIf(KeyDown(KEY_C)) 
						'Is there any blocks above the player?
						If(Block.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int - DEFS.BlockWidth:Int) = False) 
							If(Block.CHKBlock(Player.POS_X:Int + DEFS.BlockWidth:Int, Player.POS_Y:Int - DEFS.BlockWidth:Int) = False) 
								Player.IsJumping = True
								Player.IsReady = False
								Player.Direction = 1
							EndIf
						EndIf
					EndIf
					'Walking and climbing
					'Check if he's ready again, incase it's not ready anymore due to jumping
					If(Player.IsReady) 
						If(KeyDown(KEY_RIGHT)) 
							If(Player.Direction:Int = -1) 
								Player.DirectionTMR = 0
							EndIf
							Player.Direction = 1
							'IS THERE A BLOCC ON THE RIGHT??!
							If(Block.CHKBlock(Player.POS_X:Int + DEFS.BlockWidth:Int, Player.POS_Y:Int) = False) 
								Player.DirectionTMR:Int = Player.DirectionTMR:Int + 1
								If(Player.DirectionTMR:Int >= Player.DirectionTMRCAP:Int Or Player.IsRunning) 
									Player.Move(1, 0, Player.IsRunning + 1) 
									Player.Animation:Int = 1 'Set animation to Walking
									Player.DirectionTMR:Int = Player.DirectionTMRCAP:Int
								EndIf
							EndIf
						ElseIf(KeyDown(KEY_LEFT)) 
							If(Player.Direction:Int = 1) 
								Player.DirectionTMR = 0
							EndIf
							Player.Direction = -1
							'IS THERE A BLOCC ON THE LEFT??!
							If(Block.CHKBlock(Player.POS_X:Int - DEFS.BlockWidth:Int, Player.POS_Y:Int) = False) 
								Player.DirectionTMR:Int = Player.DirectionTMR:Int + 1
								If(Player.DirectionTMR:Int >= Player.DirectionTMRCAP:Int Or Player.IsRunning) 
									Player.Move(- 1, 0, Player.IsRunning + 1) 
									Player.Animation:Int = 1 'Set animation to Walking
									Player.DirectionTMR:Int = Player.DirectionTMRCAP:Int
								EndIf
							EndIf
						ElseIf(KeyDown(KEY_UP)) 
							If(Ladder.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int)) 
								If(Block.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int - DEFS.BlockWidth:Int) = False) 
									Player.Move(0, - 1) 
									Player.Animation:Int = 3 'Set animation to Climbing
								EndIf
							EndIf
						ElseIf(KeyDown(KEY_DOWN)) 
							If(Ladder.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int) Or Ladder.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int + DEFS.BlockWidth:Int)) 
								If(Block.CHKBlock(Player.POS_X:Int, Player.POS_Y:Int + DEFS.BlockWidth:Int) = False) 
									Player.Move(0, 1) 
									Player.Animation:Int = 3 'Set animation to Climbing
								EndIf
							EndIf
						EndIf
					EndIf
				Else
					'GRAVITY BOI
					Player.Move(0, 1) 
				EndIf
			EndIf
		EndIf
		'If you're not holding the walking buttons
		If(KeyDown(KEY_LEFT) = False And KeyDown(KEY_RIGHT) = False) 
			'Reset the direction timer
			'Player.DirectionTMR = 0
		EndIf
		'Set Direction
		If(Player.Direction = 1) 
			DrawImageRect(Player.IMG_Frame, Player.POS_X:Int - DEFS.CameraX, Player.POS_Y:Int - DEFS.CameraY, DEFS.BlockWidth * Player.Direction, DEFS.BlockWidth) 
		Else
			DrawImageRect(Player.IMG_Frame, Player.POS_X:Int - DEFS.CameraX + DEFS.BlockWidth, Player.POS_Y:Int - DEFS.CameraY, DEFS.BlockWidth * Player.Direction, DEFS.BlockWidth) 
		EndIf
	End Function
	
	'Move the player these amount of blocks
	Function Move(TMP_X:Int, TMP_Y:Int, TMP_Speed:Int = 1) 
		If(Player.IsReady) 
			Player.DestX:Int = TMP_X:Int * DEFS.BlockWidth:Int
			Player.DestY:Int = TMP_Y:Int * DEFS.BlockWidth:Int
			Player.Speed:Int = TMP_Speed:Int
			Player.IsReady = False
		EndIf
	End Function
	
	'Update the animations!
	'Walking/Running
	Function UpdateWalkCycle() 
		If(Player.WalkingFrame = 0) 
			Player.IMG_Frame = IMG.PLRWLK01
			If(Player.NextFrameDelay = 0) 
				PlaySound(SND.SStep) 
			EndIf
		ElseIf(Player.WalkingFrame = 1) 
			Player.IMG_Frame = IMG.PLRWLK02
		ElseIf(Player.WalkingFrame = 2) 
			Player.IMG_Frame = IMG.PLRWLK03
		ElseIf(Player.WalkingFrame = 3) 
			Player.IMG_Frame = IMG.PLRWLK04
			If(Player.NextFrameDelay = 0) 
				PlaySound(SND.SStep) 
			EndIf
		ElseIf(Player.WalkingFrame = 4) 
			Player.IMG_Frame = IMG.PLRWLK05
		ElseIf(Player.WalkingFrame = 5) 
			Player.IMG_Frame = IMG.PLRWLK06
		EndIf
		'Delays
		Player.NextFrameDelay = Player.NextFrameDelay + 1
		If(Player.IsRunning) 
			If(Player.NextFrameDelay > 4) 
				Player.WalkingFrame = Player.WalkingFrame + 1
				Player.NextFrameDelay = 0
			EndIf
		Else
			If(Player.NextFrameDelay > 8) 
				Player.WalkingFrame = Player.WalkingFrame + 1
				Player.NextFrameDelay = 0
			EndIf
		EndIf

		If(Player.WalkingFrame > 5) 
			Player.WalkingFrame = 0
		EndIf
	End Function
	'Idle Animation
	Function UpdateIdleCycle() 
		If(Player.IdleFrame < 8) 
			Player.IMG_Frame = IMG.PLRIDL01
		ElseIf(Player.IdleFrame = 8) 
			Player.IMG_Frame = IMG.PLRIDL02
		EndIf
		'Delays
		Player.NextFrameDelay = Player.NextFrameDelay + 1
		If(Player.NextFrameDelay > 8) 
			Player.IdleFrame = Player.IdleFrame + 1
			Player.NextFrameDelay = 0
		EndIf
		If(Player.IdleFrame > 8) 
			Player.IdleFrame = 0
		EndIf
	End Function
	'Climbing
	Function UpdateClimbCycle() 
		Player.ClimbingFrame:Int = Player.ClimbingFrame:Int + 1
		If(Player.ClimbingFrame:Int = 1) 
			Player.IMG_Frame = IMG.PLRCLB01
		ElseIf(Player.ClimbingFrame:Int = 2) 
			Player.IMG_Frame = IMG.PLRCLB02
			PlaySound(SND.SClimb) 
		ElseIf(Player.ClimbingFrame:Int = 3) 
			Player.IMG_Frame = IMG.PLRCLB03
		ElseIf(Player.ClimbingFrame:Int = 4) 
			Player.IMG_Frame = IMG.PLRCLB02
		ElseIf(Player.ClimbingFrame:Int = 5) 
			Player.IMG_Frame = IMG.PLRCLB01
		ElseIf(Player.ClimbingFrame:Int = 6) 
			Player.IMG_Frame = IMG.PLRCLB04
		ElseIf(Player.ClimbingFrame:Int = 7) 
			Player.IMG_Frame = IMG.PLRCLB05
		ElseIf(Player.ClimbingFrame:Int = 8) 
			Player.IMG_Frame = IMG.PLRCLB04
		EndIf
		If(Player.ClimbingFrame:Int > 8) 
			Player.ClimbingFrame:Int = 0
		EndIf
	End Function
	
	Function Die() 
		IMG.FadeOut() 
	'	Player.IsDead = True
		'Respawn etc
		'TODO: repair the fuck out of this code once I add level loading etc
		Player.ResetVars() 
		Player.POS_X = 64
		Player.POS_Y = 32
		DEFS.UpdateObjects() 
		IMG.Fadein() 
	End Function
End Type

Type Map
	Global MapSizeX:Int = 32
	Global MapSizeY:Int = 64
End Type

Type Menu
	Global Selection:Int = 0 'Cursor pos
	Global SubMenu:Int = 0 'Options, load game etc
	Function Update() 
		If(Menu.SubMenu:Int = 0)  'Titlescreen
			If(DEFS.GameLoaded) 
				DrawText("[resume]", 0, 0) 
				If(KeyHit(KEY_ENTER)) 
					If(Menu.Selection = 0)    ' 0, 0 is Start Game
						SND.PlaySong(SND.CurrentMus:String) 
						DEFS.GameMode:Int = 1 'Resume back to game
					EndIf
				EndIf
			Else
				DrawText("[start]", 0, 0) 
				If(KeyHit(KEY_ENTER)) 
					If(Menu.Selection = 0)  ' 0, 0 is Start Game
						'Init everything
						IMG.FadeOut() 
						Cls
						DrawText "press 1 for adventure", 0, 0
						DrawText "press 2 for techno", 0, 10
						DrawText "press 3 for invader", 0, 20
						DrawText "press 4 for sonic test", 0, 30
						Flip
						WaitKey
						If(KeyDown(KEY_1))
							SND.CurrentMus:String = "ADVEN.MUS"
						ElseIf(KeyDown(KEY_2))
							SND.CurrentMus:String = "TECH.MUS"
						ElseIf(KeyDown(KEY_3))
							SND.CurrentMus:String = "VADE.MUS"
						Else
							SND.CurrentMus:String = "TEST.MUS"
						EndIf
						SND.PlaySong(SND.CurrentMus:String) 
						Player.POS_X:Int = 64
						Player.POS_Y:Int = 32
						Block.Add(0, 0, IMG.Brick1_002) 
						Block.Add(0, 5, IMG.Brick2_002) 
						Block.Add(1, 5, IMG.Brick3_002) 
						Block.Add(2, 5, IMG.Brick4_002) 
						Block.Add(3, 5, IMG.Brick5_002) 
						Block.Add(4, 5, IMG.Brick6_001) 
						Block.Add(5, 5, IMG.Brick7_001) 
						Block.Add(6, 5, IMG.Brick8_001) 
						Block.Add(7, 5, IMG.Brick9_001) 
						Block.Add(8, 5, IMG.Brick10_001) 
						Block.Add(9, 5, IMG.Brick11_001) 
						Block.Add(10, 5, IMG.Brick12_001) 
						Block.Add(10, 4, IMG.Brick13_001) 
						Block.Add(11, 4, IMG.Brick14_001) 
						Block.Add(5, 3, IMG.Brick15_001) 
						Block.Add(3, 3, IMG.Brick15_001) 
						Block.Add(12, 3, IMG.Brick15_001) 
						Ladder.Add(8, 2, IMG.Ladder14_01) 
						Ladder.Add(8, 3, IMG.Ladder14_01) 
						Ladder.Add(8, 4, IMG.Ladder14_01) 
						Block.Add(13, 32, IMG.Brick15_001) 
						Block.Add(14, 64, IMG.Brick15_001) 
						DEFS.GameLoaded = True 'MAKE SURE THIS IS SET!
						DEFS.GameMode:Int = 1 'Go to game
						DEFS.UpdateObjects() 
						'IMG.ScaleGraphics() 
						IMG.FadeIn() 
					EndIf
				EndIf				
			EndIf
			
		EndIf
	End Function
End Type

'Init
SeedRnd(MilliSecs()) 
 
ARCH_Init("Bin\Export\Arch.kip") 
SetBlend(ALPHABLEND) 
IMG.LoadRes() 
SND.LoadRes() 
Cls
DrawText "press A for GMIDI", 0, 0
DrawText "press S for OPL emu", 0, 10
Flip
WaitKey
If(KeyDown(KEY_S))
	SND.OPLMode = True
EndIf

SND.PlaySong("TITLE.MUS") 

While Not(AppTerminate() Or KeyDown(KEY_F1)) 
	'Clear the main Buffer
	Cls
	'Set the buffer to the VBuffer
	If(DEFS.VBufferBinded = False) 
		VBufferGFX.bind() 
		DEFS.VBufferBinded = True
	EndIf
	'IB.BindBuffer() 
	'Clear the VBuffer too
	Cls
	'IB.Cls() 
	
	'Main code here
	If(DEFS.GameMode = 0)  'Main Menu/Pause
		Menu.Update() 
	ElseIf(DEFS.GameMode = 1)       'Game
		DEFS.UpdateObjects() 
		If(KeyHit(KEY_ESCAPE)) 
			IMG.FadeOut() 
			SND.PlaySong("LOAD.MUS") 
			DEFS.GameMode = 0
			Menu.Update() 
			IMG.FadeIn() 
		EndIf
	ElseIf(DEFS.GameMode = 2)   'Level Editor
	
	EndIf
	IMG.DrawFade() 
	IMG.ScaleGraphics() 
Wend


Rem some logo stuff lol
	SetColor(128, 0, 0) 
 	DrawText("Bit", 1, 1) 
	SetColor(255, 0, 0) 
	DrawText("Bit", 0, 0) 
	SetColor(0, 0, 128) 
 	DrawText("   Wave", 1, 1) 
	SetColor(0, 0, 255) 
	DrawText("   Wave", 0, 0) 
	SetColor(0, 128, 0) 
 	DrawText("   X", 1, 11) 
	SetColor(0, 255, 0) 
	DrawText("   X", 0, 10) 
endrem